#include "Cloud.h"



Cloud::Cloud()
{
	setCollider(false);
}


Cloud::~Cloud()
{
}

void Cloud::create(SpriteSize size)
{
	spriteSize = size;
	spriteType = SpriteType::CloudSprite;

	switch (spriteSize)
	{
		case SpriteSize::Small:
			spriteTexture.loadFromFile("Assets/Sprites/Game Items/Cloud/small.png");	//Load the small texture
			setSize(sf::Vector2f(110, 83));	//Set its size to the small size
			break;

		case SpriteSize::Medium:
			spriteTexture.loadFromFile("Assets/Sprites/Game Items/Cloud/medium.png");	//Load the medium texture
			setSize(sf::Vector2f(164, 83));	//Set its size to the medium size
			break;

		case SpriteSize::Big:
			spriteTexture.loadFromFile("Assets/Sprites/Game Items/Cloud/big.png");	//Load the big texture
			setSize(sf::Vector2f(220, 83));	//Set its size to the big size
			break;
	}

	setTexture(&spriteTexture);
}